<?php
    $this_episode = isset($episode_info) ? $episode_info->getEpisodeNumber() : false;
?>

<?php $__env->startSection('footer'); ?>
    <script src="<?php echo e(asset('/assets/v1/js/s.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <section class="px-4r">
        <div class="backdrop" style="background-image: url(<?php echo e($backdrop); ?>)"></div>
        <div class="container">
            <?php echo $__env->make(config('tmdb.theme').'._player', ['backdrop' => $backdrop, 'video' => asset('/assets/v1/video/tv.mp4')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <script>var playDuration = 45*60;</script>
        </div>

        <div class="container py-4">
            <div class="row">
                <div class="col d-flex justify-content-center">
                    <a href="<?php echo e(Mopie::route('loading', ['id' => $tv->getID() ,'title' => $tv->getName()])); ?>" class="btn btn-outline-theme mx-1"><?php echo e(__('utilities.watch_now')); ?> <i class="fa fa-film" aria-hidden="true"></i></a>
                    <a href="<?php echo e(Mopie::route('loading', ['id' => $tv->getID() ,'title' => $tv->getName()])); ?>" class="btn btn-outline-theme mx-1"><?php echo e(__('utilities.download')); ?> <i class="fa fa-cloud-download" aria-hidden="true"></i></a>
                </div>
            </div>
        </div>
    </section> 
    <section class="container p-3 p-md-4 rounded-lg mb-5" style="background-color: #0e1117">
        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-md-2 col-sm-4 col-3">
                        <img class="img-fluid" src="<?php echo e(Mopie::imgPoster($tv->getPoster())); ?>" alt="">
                    </div>
                    <div class="col-md-10 col-sm-8 col-9">
                        <div class="entry-title d-flex flex-column-reverse flex-md-row justify-content-between">
                            <h1 class="h3"><?php echo e($title); ?> <span class="tiny text-muted"><?php echo e($season_info->getYear()); ?></span></h1>
                            <div class="sub-r">
                                <a href="#" class="btn subs"><?php echo e(__('utilities.subscribe_watch')); ?></a>
                            </div>
                        </div>
                        <div class="entry-info mb-3">
                            <div class="__rate">
                                <?php for($i = 0; $i < 10; $i++): ?>
                                    <?php if($i < round($tv->getVoteAverage())): ?>
                                        <i class="fa fa-star text-warning"></i>
                                    <?php else: ?>
                                        <i class="fa fa-star-o text-muted"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                            </div>
                            <div class="__info">
                                <span class="text-muted small"><?php echo e($tv->getVoteAverage()); ?>/10</span> <span class="text-muted small"><?php echo e(__('utilities.by')); ?> <?php echo e($tv->getVoteCount()); ?> <?php echo e(__('utilities.users')); ?></span>
                            </div>
                        </div>
                        <div class="entry-desciption text-muted">
                            <p><?php echo e($overview); ?></p>
                        </div>
                        <div class="entry-table">
                            <ul>
                                <?php if($type == 'tv'): ?>
                                    <li><?php echo e(__('utilities.released')); ?>: <span><?php echo e($tv->getFirstAirDate()); ?></span></li>
                                <?php elseif($type == 'season'): ?>
                                    <li><?php echo e(__('utilities.released')); ?>: <span><?php echo e($season_info->getAirDate()); ?></span></li>
                                <?php else: ?>
                                    <li><?php echo e(__('utilities.released')); ?>: <span><?php echo e($episode_info->getAirDate()); ?></span></li>
                                <?php endif; ?>
                                <li><?php echo e(__('utilities.runtime')); ?>: <span><?php echo e($tv->getEpisodeRunTime()); ?> <?php echo e(__('utilities.minutes')); ?></span></li>
                                <li><?php echo e(__('utilities.genre')); ?>: <span><?php echo e($tv->getGenreComma()); ?></span></li>
                                <li><?php echo e(__('utilities.stars')); ?>: <span><?php echo $tv->getStarComma(5); ?></span></li>
                                <li><?php echo e(__('utilities.director')); ?>: <span><?php echo $tv->getDirectorComma(5); ?></span></li>
                                
<li>Source:
<span>
<a href="//cwr-crb.com/-/en/tv/<?php echo e($tv->getID()); ?>/<?php echo e($season_info->getSeasonNumber()); ?>" rel="noopener" target="_blank">CWR-CRB</a> 

</span>
</li>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>


    
        <section class="container p-3 p-md-4 rounded-lg mb-5" style="background-color: #0e1117">
                    <div class="col-12">
                        <div class="episodes">
                            <div>
                                <ul class="nav nav-tabs" id="episodesTab" role="tablist" style="width: 793px;">
                                    <?php $__currentLoopData = collect($tv->getSeasons())->sortKeysDesc()->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->getSeasonNumber() == $season): ?>
                                            <li class="nav-item">
                                                <a href="#" class="nav-link active" id="season-<?php echo e($item->getSeasonNumber()); ?>-tab">
                                                    <?php echo e(__('utilities.season')); ?> <?php echo e($item->getSeasonNumber()); ?>

                                                </a>
                                            </li>
                                        <?php else: ?>
                                            <li class="nav-item">
                                                <a href="<?php echo e(Mopie::route('tv.single.season', ['id' => $tv->getID(), 'season' => $item->getSeasonNumber(), 'slug' => str_slug($tv->getOriginalName())])); ?>" class="nav-link" id="season-<?php echo e($item->getSeasonNumber()); ?>-tab">
                                                    <?php echo e(__('utilities.season')); ?> <?php echo e($item->getSeasonNumber()); ?>

                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <div class="tab-content episodes_list" id="episodesTabContent">
                            <div class="tab-pane fade show active" id="season-<?php echo e($tv->getNumSeasons()); ?>" role="tabpanel" aria-labelledby="season-<?php echo e($tv->getNumSeasons()); ?>-tab">
                                <ul>
                                    <?php $__currentLoopData = $season_select; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($item->getEpisodeNumber() == $this_episode): ?>
                                            <li class="dark">
                                        <?php else: ?>
                                            <li>
                                        <?php endif; ?>
                                            <div class="episodes_list_item">
                                                <div>
                                                    <a class="episodes_list_episode" href="<?php echo e(Mopie::route('tv.single.season.episode', ['id'=>$tv->getID(), 'season'=>$season, 'episode'=>$item->getEpisodeNumber(), 'slug' => str_slug($tv->getORiginalName().' '.$item->getName()) ])); ?>" title="<?php echo e($item->getName()); ?>"><?php echo e($item->getEpisodeNumber()); ?>. <?php echo e($item->getName()); ?></a>
                                                    <span class="episodes_list_release"><?php echo e($item->getAirDate()); ?></span>
                                                </div>
                                                <div>
                                                    <a class="episodes_list_watch" href="<?php echo e(Mopie::route('tv.single.season.episode', ['id'=>$tv->getID(), 'season' => $season, 'episode'=>$item->getEpisodeNumber(), 'slug' => str_slug($tv->getORiginalName().' '.$item->getName()) ])); ?>"><i class="fa fa-lg fa-play-circle"></i> <span><?php echo e(__('utilities.watch')); ?></span></a>
                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
 </section> 
    
    
    <section class="container p-3 p-md-4 rounded-lg mb-5" style="background-color: #0e1117">
        <div class="h6">Download : <strong class="text-color-theme">MKV</strong></div>
        <ul class="down-list mb-4">
            <li>
                <div class="dt"><strong>360p</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
            <li>
                <div class="dt"><strong>480p</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
            <li>
                <div class="dt"><strong>720p</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
            <li>
                <div class="dt"><strong>1080p</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
        </ul>
        <div class="h6">Download : <strong class="text-color-theme">MP4</strong></div>
        <ul class="down-list">
            <li>
                <div class="dt"><strong>360p</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
            <li>
                <div class="dt"><strong>480p</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
            <li>
                <div class="dt"><strong>MP4HD</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
            <li>
                <div class="dt"><strong>FULLHD</strong></div>
                <span>GD2</span> | <span>CU</span> | <span>GD1</span> | <span>ZS</span> | <span>RC</span>
            </li>
        </ul>


    </section>


    <section class="container">
        <div class="row">
            <div class="col-12 mb-4">
                <h3 class="h4"><?php echo e(__('section.title.similar')); ?></h3>
            </div>
        </div>
        <div class="owl-carousel">
            <?php $__currentLoopData = $tv->getSimilars(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo $__env->make(config('tmdb.theme').'._item_tv', ['class' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="divider"></div>
        <div class="row">
            <div class="col-12 mb-4">
                <h3 class="h4"><?php echo e(__('section.title.recommendation')); ?></h3>
            </div>
        </div>
        <div class="owl-carousel">
            <?php $__currentLoopData = $tv->getRecommendations(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php echo $__env->make(config('tmdb.theme').'._item_tv', ['class' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>

    <?php echo $__env->make(config('tmdb.theme').'._modal_watch', ['backdrop' => $backdrop, 'id' => $tv->getID(), 'title' => $tv->getName()], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(config('tmdb.theme').'.layouts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/a015paly/bestmpgtrucks.com/-/engine/themes/v1/single_tv.blade.php ENDPATH**/ ?>