<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <?php echo SEO::generate(); ?>

    <script src="https://use.fontawesome.com/3db27005e3.js"></script>
    <link href="https://use.fontawesome.com/3db27005e3.css" media="all" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/v1/css/v1.css')); ?>">
    <script src="<?php echo e(asset('assets/v1/js/js.js')); ?>"></script>
	<meta name="theme-color" content="#161c23">
    <?php echo $__env->yieldContent('header'); ?>
    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
    <div class="sign-in-overlay"></div>
    <div class="signin js-signin-form">
        <div class="signin_close">
            <i class="fa fa-close" aria-hidden="true"></i>
        </div>
        <div class="signin_holder">

            <form id="signinfrom">
                <div class="h3"><?php echo e(__('signin.sign_in')); ?></div>
                <div class="form-group">
                    <label for="signInEmail"><?php echo e(__('signin.email')); ?></label>
                    <input type="email" class="form-control bg-dark border-dark text-secondary" id="signInEmail" aria-describedby="emailHelp" placeholder="<?php echo e(__('signin.enter_email')); ?>">
                    <small id="emailHelp" class="form-text text-muted"><?php echo e(__('signin.well_never_share')); ?></small>
                </div>
                <div class="form-group">
                    <label for="signPassword"><?php echo e(__('signin.password')); ?></label>
                    <input type="password" class="form-control bg-dark border-dark text-secondary" id="signPassword" placeholder="<?php echo e(__('signin.password')); ?>">
                </div>
                <div class="form-group">
                    <label id="forgotpass" class="form-check-label small text-muted cursor text-hover-theme" for="exampleCheck1"><?php echo e(__('signin.forgot_password')); ?></label>
                </div>

                <div class="d-flex justify-content-center">
                    <div class="spinner-border text-light loading_signIn text-center mb-3 d-none" role="status">
                        <span class="sr-only"><?php echo e(__('signin.loading')); ?></span>
                    </div>
                </div>

                <div class="text-danger sign-in-form-alert mb-3" role="alert"></div>

                <button type="submit" class="btn btn-outline-theme btn-block sign-in-submit"><?php echo e(__('signin.sign_in')); ?></button>
                <div class="divider divider--small"></div>
                <div class="text-center">
                    <p class="text-small mb-3"><?php echo e(__('signin.or')); ?></p>
                    <a href="<?php echo e(Mopie::route('loading')); ?>" class="btn btn-theme btn-block" type="button"><?php echo e(__('signin.create_free_account')); ?></a>
                </div>
            </form>

            <form id="resetpassform">
                <div class="h3"><?php echo e(__('signin.reset_password')); ?></div>
                <p class="text-muted"><?php echo e(__('signin.enter_your_email')); ?></p>
                <div class="form-group">
                    <label for="resetEmail"><?php echo e(__('signin.email')); ?></label>
                    <input type="email" class="form-control bg-dark border-dark text-secondary" id="resetEmail" aria-describedby="emailHelp" placeholder="<?php echo e(__('signin.enter_email')); ?>">
                </div>

                <div class="d-flex justify-content-center">
                    <div class="spinner-border text-light loading_signIn text-center mb-3 d-none" role="status">
                        <span class="sr-only"><?php echo e(__('signin.loading')); ?></span>
                    </div>
                </div>

                <div class="text-danger sign-in-form-alert mb-3" role="alert"></div>

                <button type="submit" class="btn btn-outline-theme btn-block mb-3"><?php echo e(__('signin.reset_password')); ?></button>
                <div id="backToSignIn" class="text-center cursor"><?php echo e(__('signin.back_to_sign_in')); ?></div>
            </form>

        </div>
    </div>

    <?php echo $__env->make(config('tmdb.theme').'._modal_lang', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <nav class="navbar navbar-expand-lg navbar-dark navbar-mopie fixed-top">
        <a class="navbar-brand" href="<?php echo e(Mopie::route('home')); ?>">
            <img width="30" src="<?php echo e(asset('assets/v1/logo.png')); ?>">
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarsExample04"
            aria-controls="navbarsExample04" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarsExample04">
            <ul class="navbar-nav mr-auto">
                <li class="nav-item dropdown">
                    <a class="nav-link" href="#" id="dropdown04" data-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false"><?php echo e(__('menu.movies')); ?> <i class="fa fa-angle-down" aria-hidden="true"></i></a>
                    <div class="dropdown-menu mop" aria-labelledby="dropdown04">
                        <div class="row">
                            <div class="col-12">
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('movie.popular')); ?>" title="<?php echo e(__('menu.popular')); ?>"><?php echo e(__('menu.popular')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('movie.now.playing')); ?>" title="<?php echo e(__('menu.now_playing')); ?>"><?php echo e(__('menu.now_playing')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('movie.top.rated')); ?>" title="<?php echo e(__('menu.top_rated')); ?>"><?php echo e(__('menu.top_rated')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('movie.upcoming')); ?>" title="<?php echo e(__('menu.upcoming')); ?>"><?php echo e(__('menu.upcoming')); ?></a>
                            </div>
                        </div>
                    </div>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link" href="#" id="dropdown04" data-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false"><?php echo e(__('menu.tv_shows')); ?> <i class="fa fa-angle-down" aria-hidden="true"></i></a>
                    <div class="dropdown-menu mop" aria-labelledby="dropdown04">
                        <div class="row">
                            <div class="col-12">
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('tv.popular')); ?>" title="<?php echo e(__('menu.popular')); ?>"><?php echo e(__('menu.popular')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('tv.top.rated')); ?>" title="<?php echo e(__('menu.top_rated')); ?>"><?php echo e(__('menu.top_rated')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('tv.on.the.air')); ?>" title="<?php echo e(__('menu.on_tv')); ?>"><?php echo e(__('menu.on_tv')); ?></a>
                                <a class="dropdown-item" href="<?php echo e(Mopie::route('tv.airing.to.day')); ?>" title="<?php echo e(__('menu.airing_today')); ?>"><?php echo e(__('menu.airing_today')); ?></a>
                            </div>
                        </div>
                    </div>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link" href="#" id="dropdown04" data-toggle="dropdown"
                        aria-haspopup="true" aria-expanded="false"><?php echo e(__('menu.genres')); ?> <i class="fa fa-angle-down" aria-hidden="true"></i></a>
                    <div class="dropdown-menu px-3" aria-labelledby="dropdown04">
                        <div class="row">
                            <?php
                                $genres = collect($genre_list)->chunk(10);
                            ?>
                            <div class="col-6 px-0">
                                <?php $__currentLoopData = $genres->first(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="dropdown-item" href="<?php echo e(Mopie::route('genre', ['id' => $item->getID(), 'slug' => str_slug($item->getName())])); ?>" title="<?php echo e($item->getName()); ?>"><?php echo e($item->getName()); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <div class="col-6 px-0">
                                <?php $__currentLoopData = $genres->last(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a class="dropdown-item" href="<?php echo e(Mopie::route('genre', ['id' => $item->getID(), 'slug' => str_slug($item->getName())])); ?>" title="<?php echo e($item->getName()); ?>"><?php echo e($item->getName()); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(Mopie::route('people.popular')); ?>" title="<?php echo e(__('menu.popular_people')); ?>"><?php echo e(__('menu.popular_people')); ?></a>
                </li>
            </ul>
            <ul class="navbar-nav">
                <form class="input-group my-2 my-md-0 mr-md-3 bg-faded" action="<?php echo e(Mopie::route('home')); ?>" method="GET">
                    <input type="text" class="form-control" name="s" placeholder="<?php echo e(__('menu.search')); ?>" aria-label="<?php echo e(__('menu.search')); ?>">
                    <div class="input-group-append">
                        <button class="btn btn-search focus-no-sh" type="button"><i class="fa fa-search" aria-hidden="true"></i></button>
                    </div>
                </form>
                <li class="nav-item">
                    <div class="nav-link cursor mb-3 mb-md-0" data-toggle="modal" data-target="#modalLang"><i class="fa fa-globe" aria-hidden="true"></i></div>
                </li>
                <li class="nav-item">
                    <button class="btn btn-outline-theme ml-md-3 mb-3 mb-md-0 sign-in"><?php echo e(__('utilities.sign_in')); ?></button>
                </li>
                <li class="nav-item">
                    <a href="<?php echo e(Mopie::route('loading')); ?>" class="btn btn-theme ml-md-3"><?php echo e(__('utilities.register')); ?></i></a>
                </li>
            </ul>
        </div>
    </nav>

    <?php echo $__env->yieldContent('content'); ?>

    <footer class="footer">
        <div class="container">
            <div class="footer_wrapper d-flex flex-column flex-md-row">
                <div class="copyright">Copyright © <?php echo e(date('Y')); ?> <span class="text-capitalize"><?php echo e($_SERVER['SERVER_NAME']); ?></span> | All rights
                    reserved</div>
                <div class="footer_links">
                    <a href="<?php echo e(route('page', ['page' => 'dmca'])); ?>">DMCA</a>
                    <a href="<?php echo e(route('page', ['page' => 'privacy-policy'])); ?>">Privacy Policy</a>
                    <a href="<?php echo e(route('page', ['page' => 'term-condition'])); ?>">Terms &amp; Condition</a>
                </div>
            </div>
        </div>
    </footer>

    <?php echo $__env->yieldContent('footer'); ?>
    <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/helluzzp/123Movies/engine/themes/v1/layouts.blade.php ENDPATH**/ ?>